import React, {useEffect, useState} from 'react';
import { Transfer } from 'antd';
import type { TransferDirection } from 'antd/es/transfer';
import {getMemberPage, getRoleMember} from "@/services/role";

interface RecordType {
  key: string;
  title: string;
  description: string;
}

const mockData: RecordType[] = Array.from({ length: 20 }).map((_, i) => ({
  key: i.toString(),
  title: `content${i + 1}`,
  description: `description of content${i + 1}`,
}));

const initialTargetKeys = mockData.filter((item) => Number(item.key) > 10).map((item) => item.key);

console.log(initialTargetKeys,'+++++')


// debugger

const MemberPage: React.FC = (props, context) => {

  // key
  const [targetKeys, setTargetKeys] = useState([]);
  const [selectedKeys, setSelectedKeys] = useState<string[]>([]);

  const [params,setParams] = useState<ROLE_API.RuleParmes>({
    page: 1,
    page_size: 10
  })

  const [dataSource,setDataSource] = useState()
  const [total, setTotal] = useState<number | undefined>(0)


  const init = () => {

    ( async ()=> {

      let recordData = props?.editInfo

      let {items, total} = await getMemberPage(params)
      setDataSource(items)
      setTotal(total)

      // 获取角色人员的配置信息
      let msg = await getRoleMember({r_id:recordData.id})
      setTargetKeys(msg?.union_ids || [])

    })()


  }

  useEffect(() => {
    // 初始化
    init()
  }, []);

// 存储值



  const onChange = (nextTargetKeys: string[], direction: TransferDirection, moveKeys: string[]) => {
    localStorage.setItem('targetSelectedKeys',JSON.stringify(nextTargetKeys))
    setTargetKeys(nextTargetKeys);
  };

  const onSelectChange = (sourceSelectedKeys: string[], targetSelectedKeys: string[]) => {
    setSelectedKeys([...sourceSelectedKeys, ...targetSelectedKeys]);
  };

  const onScroll = (direction: TransferDirection, e: React.SyntheticEvent<HTMLUListElement>) => {
    console.log('direction:', direction);
    console.log('target:', e.target);
  };

  return (
    <Transfer
      dataSource={dataSource}
      titles={['成员', '目标成员']}
      targetKeys={targetKeys}
      rowKey={(record) => record.member.unionId}
      selectedKeys={selectedKeys}
      onChange={onChange}
      onSelectChange={onSelectChange}
      onScroll={onScroll}
      render={(item) => item.member.name}
    />
  );
};

export default MemberPage;
