//

import { request } from '@umijs/max';

export async function fsQrLogin(body: any, options?: { [key: string]: any }) {
  return request('/api/member/fsQrLogin', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}



// 获取角色列表
export async function getRuleList (body:ROLE_API.RuleParmes ) {
  return request<ROLE_API.RuleResult>('/api/permission/getRoleList', {
    method: 'GET',
    params: body
  })
}

// 获取菜单列表
export async function getMenuPage (body:ROLE_API.RuleParmes ) {
  return request<ROLE_API.RuleResult>('/api/permission/getMenuPage', {
    method: 'GET',
    params: body
  })
}

// 获取设置的角色菜单
export async function getRoleMenu (body:ROLE_API.RuleParmes ) {
  return request<ROLE_API.RuleResult>('/api/permission/getRoleMenu', {
    method: 'GET',
    params: body
  })
}



// 获取人员列表
export async function getMemberPage (body:ROLE_API.RuleParmes ) {
  return request<ROLE_API.RuleResult>('/api/member/getMemberPage', {
    method: 'GET',
    params: body
  })
}

// 获取设置的人员列表
export async function getRoleMember (body:ROLE_API.RuleParmes ) {
  return request<ROLE_API.RuleResult>('/api/permission/getRoleMember', {
    method: 'GET',
    params: body
  })
}



// 添加角色
export async function addRule(body: any, options?: { [key: string]: any }) {
  return request<API.LoginResult>('/api/permission/addRole', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

// 添加菜单
export async function addMenu(body: any, options?: { [key: string]: any }) {
  return request<API.LoginResult>('/api/permission/addMenu', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

// 保存
// 更新角色菜单
export async function setRoleMenu(body: any, options?: { [key: string]: any }) {
  return request<API.LoginResult>('/api/permission/setRoleMenu', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}





// 修改角色
export async function saveRole(body: any,options?: { [key: string]: any }) {
  return request<API.RuleListItem>('/api/permission/saveRole', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

// 修改菜单
export async function saveMenu(body: any,options?: { [key: string]: any }) {
  return request<API.RuleListItem>('/api/permission/saveMenu', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}

// 设置角色用户
export async function setRoleMember(body: any,options?: { [key: string]: any }) {
  return request<API.RuleListItem>('/api/permission/setRoleMember', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
    },
    data: body,
    ...(options || {}),
  });
}





// 删除角色
export async function delRule(body: any,options?: { [key: string]: any }) {
  return request<API.RuleListItem>('/api/permission/delRole', {
    method: 'POST',
    data: body,
    ...(options || {}),
  });
}


// 删除菜单
export async function delMenu(body: any,options?: { [key: string]: any }) {
  return request<API.RuleListItem>('/api/permission/delMenu', {
    method: 'POST',
    data: body,
    ...(options || {}),
  });
}



// 获取菜单详情
// /api/permission/getMenuDetail


// 获取角色菜单列表 id
// /api/permission/getRoleMenu

export async function getMenuTree ( ) {
  return request<any>('/api/permission/getMenuTree', {
    method: 'GET',
  })
}




// 设置用户角色
// /api/permission/setMemberRole


// 保存菜单
// /api/permission/saveMenu
