import 'package:flutter/material.dart';
import 'package:go_router/go_router.dart';
import 'package:my_app2/Customization/Customization.dart';
import 'package:my_app2/Home/Home.dart';
import 'package:my_app2/Mine/Mine.dart';
import 'package:my_app2/Network/http/ServiceManager.dart';
import 'package:my_app2/Network/service/XmhService.dart';
import 'package:my_app2/TabPageContainer.dart';

void main() {
  runApp(const MyApp());
  ServiceManager().registService(XmhService());
}

// final GoRouter _router = GoRouter(routes: <RouteBase>[
//   GoRoute(
//       path: '/',
//       builder: (context, state) => ExampleList(),
//       routes: <RouteBase>[
//         GoRoute(
//           path: 'Example01',
//           builder: (context, state) => Example01(),
//         ),
//         GoRoute(
//           path: 'StackExample',
//           builder: (context, state) => const StackExample(),
//         )
//       ])
// ]);
final GoRouter _router = GoRouter(routes: <RouteBase>[
  GoRoute(
      path: '/',
      builder: (context, state) => const App(),
      routes: <RouteBase>[])
]);

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MaterialApp.router(
      routerConfig: _router,
    );
  }
}

class App extends StatefulWidget {
  const App({super.key});

  @override
  State<App> createState() => _AppState();
}

class _AppState extends State<App> {
  int _currentIndex = 0;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: TabPageContainer(
          currentIndex: _currentIndex,
          children: const [Home(), Customization(), Mine()]),
      bottomNavigationBar: BottomNavigationBar(
        currentIndex: _currentIndex,
        items: const [
          BottomNavigationBarItem(
              icon: ImageIcon(
                AssetImage('assets/multiImgs/home.png'),
                size: 32,
              ),
              label: '首页'),
          BottomNavigationBarItem(
              icon: ImageIcon(
                AssetImage('assets/multiImgs/custom.png'),
                size: 32,
              ),
              label: '定制'),
          BottomNavigationBarItem(
              icon: ImageIcon(
                AssetImage('assets/multiImgs/mine.png'),
                size: 32,
              ),
              label: '我的')
        ],
        onTap: (index) {
          setState(() {
            _currentIndex = index;
          });
        },
      ),
    );
  }
}
