import 'package:flutter/material.dart';
import 'package:my_app2/Models/ProductModel.dart';
import 'package:my_app2/Network/api/product_api.dart';
import 'package:my_app2/Network/http/BaseApi.dart';

class ProductListViewModel extends ChangeNotifier {
  final List<ProductModel> _productList = [];

  int _page = 1;
  final int _pageSize = 10;

  bool _isLoading = true;

  bool get isLoading => _isLoading && _productList.isEmpty;

  bool get isEmpty => _productList.isEmpty;

  void _updateProductList(List<ProductModel> list, bool isClear) {
    _isLoading = false;
    if (isClear) {
      _productList.clear();
    }
    _productList.addAll(list);
    notifyListeners();
  }

  /// 3d照片
  List<ProductModel> get photoProductList {
    var list = <ProductModel>[];
    for (final item in _productList) {
      if (item.productType == 2) {
        list.add(item);
        continue;
      }
      break;
    }
    return list;
  }

  /// 手办
  List<ProductModel> get handmadeProductList {
    int index = 0;
    for (index; index < _productList.length; index++) {
      if (_productList[index].productType == 1) {
        break;
      }
    }
    return _productList.sublist(index);
  }

  void pullUp() {
    var api = ProductListApi(page: 1, pageSize: _pageSize);
    api.request(
      onSuccessed: (value) {
        if (value == null) {
          return;
        }
        _updateProductList(value, true);
      },
      onFailed: (p0) {},
    );
  }

  void loadMore() {}
}
